﻿var settingsPage = {
    syncOption: null,
    trackingVariables: null
};

$(document).ready(function () {
    $(".h-questionsAutocomplete").a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetQuestionsForAutoComplete", "Questionnaire"),
        select: function (event, data) {
            var valueHiddenField = $("input[type=hidden]", $(this).closest("div.field"));
            if (data.item) {
                valueHiddenField.val(data.item.Value).trigger("change");
            } else {
                valueHiddenField.val(0).trigger("change");
            }
        }
    });

    $(".h-piiVariablesMultiselect").a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetVariablesForAutoComplete", "Shared"),
        multipleSelection: true,
        hideSelectedItems: true,
        altValueField: $("#PIIVariables")
    });

    $(".h-viewResponsesExcludedVariableAuto").a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetVariablesForAutoComplete", "Shared"),
        multipleSelection: true,
        hideSelectedItems: true,
        altValueField: $("#ViewResponsesExcludedVariables")
    });


    $(".h-surveyProviderVariablesAutocomplete").a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetVariablesForAutoComplete", "Shared")
    });
    
    $(".h-languagesMultiSelect").a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetLanguagesForAutoComplete", "Settings"),
        altValueField: $("#LanguagesJson"),
        select: function (event, data) {
            if (data && data.item) {
                if (!$("#DefaultLanguage").val()) {
                    var selectedItem = $(".selected-item[data-value=" + data.item["Value"] + "]");
                    setDefaultLanguage(selectedItem);
                }
            }
        },
        removeItem: function (event, data) {
            if ($("#DefaultLanguage").val() == data.item["Value"]) {
                setDefaultLanguage(null);
            }
        },
        create: function () {
            var defaultLanguage = $("#DefaultLanguage").val();

            if (defaultLanguage) {
                var defaultItem = $(".selected-item[data-value=" + defaultLanguage + "]")

            if (defaultItem.length > 0) {
                setDefaultLanguage(defaultItem);
            }
            }
        },
        multipleSelection: true,
        hideSelectedItems: true
    });

    $(".v-languageAutoCompleteContainer").on("click", ".selected-item", function (e) {
        setDefaultLanguage($(this));
    });

    $(".h-toggleDisableableSection").each(function () {
        var trigger = $(this);
        if (trigger.is("input[type=radio]")) {
            $("input:radio[name=\"" + trigger.attr("id") + "\"]").on("change", function () {
                var section = $(".h-disableableSection", trigger.closest(".v-disableableParentGroup"));
                toggleDisableableSection(section, trigger);
            });
        }
    });

    $("input:radio[name=\"Mode\"]").on("change", function () {
        disableSurveyAccess($(this));
        changePinControlsState();
    });
    
    $(".h-filterAction").each(function () {
        showFilteringValueField($(this));
    });

    $(".h-filterAction").on("change", function () {
        showFilteringValueField($(this));
    })

    $(".h-quitButtonAction").each(function () {
        showQuitButtonTypeValueField($(this));
    });

    $(".h-quitButtonAction").on("change", function () {
        showQuitButtonTypeValueField($(this));
    })

    $(".h-updateSurveyLink").on("change", function () {
        updateSurveyLink($(this));
    });

    $(".h-copy-survey-link").on("click", function () {
        copySurveyLink($(this));
    });

    $(".h-responseTracking").on("change", function () {
        $(".h-selectVariables").toggle($(this).val() == "TrackVariables");
        $(".v-trackingVariables").toggle($(this).val() == "TrackVariables");
    });

    $(document).on("click", ".h-selectVariables", function () {
        var variableSelectorParams = { variables: "", alwaysAllowPIISelection: true };

        if (settingsPage.trackingVariables != null && settingsPage.trackingVariables != "") {
            variableSelectorParams.variables = settingsPage.trackingVariables;
            variableSelectorParams.alwaysAllowPIISelection = true;
        }

        modalDialog.showWindow(a4.getSurveyAction("VariableSelector", "Shared", variableSelectorParams) , 620, 950, {
            beforeClose: function () {
                var variableSelector = $('.fancybox-iframe').contents();
                var confirmed = variableSelector.find(".v-confirmed").val();

                if (confirmed) {
                    settingsPage.trackingVariables = $('.v-selectedVariables', variableSelector).val();
                    var nbVariables = (settingsPage.trackingVariables && settingsPage.trackingVariables != null) ? settingsPage.trackingVariables.split(',').length : 0;
                    var varSummary = $(".v-variableSummary");
                    var message = varSummary.attr("data-message").replace("{0}", nbVariables);
                    $("#VariableSummary").html(message);
                    $("#TrackingVariables").val(settingsPage.trackingVariables);
                    $("form.validate-save").a4unsavedChanges("change");
                }
            }
        });
    });

    $(".v-identifier")
        .on("keypress", function (_e) { return DisableInvalidCharacters(_e); })
        .on("keyup blur", function () {
            var value = $(this).val();
            var newValue = RemoveInvalidCharacters(value);
            if (newValue != value) {
                $(this).val(newValue);
            }
        });

    $(".v-defaultViewedUnansweredQuestionCode").on("keypress", function (_e) { return DisableInvalidCharacters(_e); });

    var trackingVars = $("#TrackingVariables").val();

    if (trackingVars && trackingVars != "") {
        settingsPage.trackingVariables = $.parseJSON(trackingVars).toString();
    }

    if ($(".v-surveyAccessSettings").length > 0)
        changePinControlsState();

    toggleDisableableSections();
    createDynamicGrids();
    updateSurveyLink();
    checkPanelSectionErrors();
    initializeOfflineSettings();
    a4.initializeInputs();
});

function toggleDisableableSections() {
    $(".h-disableableSection").each(function () {
        var section = $(this);
        var trigger = $(".h-toggleDisableableSection", section.closest(".v-disableableParentGroup"));
        toggleDisableableSection(section, trigger);
    });
}

function toggleDisableableSection(section, trigger) {
    if (trigger.is("input[type=radio]")) {
        $("input, textarea", section).prop("readonly", !trigger.is(":checked:not(:disabled)"));
        $("input[type=radio]", section).prop("disabled", !trigger.is(":checked:not(:disabled)"));
        if (trigger.is(":checked:not(:disabled)[value='False']")) {
            $("input[type=radio][value='False']", section).prop("checked", true).trigger("change");
        }
        section.find(".h-autocomplete-button").toggleClass("disabled", !trigger.is(":checked:not(:disabled)"))
    }
}

function setDefaultLanguage(item) {
    if (item) {
        $(".selected-item", item.parent()).removeClass("default");
        $(".selected-item .v-defaultLanguage", item.parent()).remove();

        item.prepend(voxco.icons.getIcon("star", "v-defaultLanguage"));
        item.addClass("default");

        $("#DefaultLanguage").val(item.attr("data-value")).trigger("change");
        $("#DefaultLanguageLabel").html($(item).text());
    }
    else {
        $("#DefaultLanguage").val("").trigger("change");
        $("#DefaultLanguageLabel").html("");
    }
}

function createDynamicGrids() {
    var dynamicGridsContainer = $(".v-dynamicGridEditorContainer");

    if (dynamicGridsContainer.length > 0) {
        $(".v-dynamicEditor", dynamicGridsContainer).each(function () {
            var editor = $(this);
            var maxRows = editor.attr("data-max-rows");

            updateSynchronizeWithValues(editor);

            editor.on("click", ".h-moveUp", function () {
                var item = $(this).closest(".v-editableItem");
                var prevItem = item.prevAll(":not(.deleted):first");
                
                if (prevItem.length > 0) {
                    item.after(prevItem);
                    swapItemIndexes(item, prevItem);
                    $("form.validate-save").a4unsavedChanges("change");
                }
            });

            editor.on("click", ".h-moveDown", function () {
                var item = $(this).closest(".v-editableItem");
                var nextItem = item.nextAll(":not(.deleted):first");

                if (nextItem.length > 0) {
                    nextItem.after(item);
                    swapItemIndexes(item, nextItem);
                    $("form.validate-save").a4unsavedChanges("change");
                }
            });

            editor.on("click", ".h-deleteRow", function () {
                var item = $(this).closest(".v-editableItem");
                item.addClass("deleted");
                item.hide();
                var curState = $(".v-rowState", item).val();

                // New
                if (curState == "0") {
                    item.remove();
                }
                else {
                    $(".v-rowState", item).val(2); // deleted
                }

                replaceItemIndexes(item);
                updateSynchronizeWithValues(editor);

                if ($('.v-dynamicEditorTable tbody tr:not(.deleted)', editor).length == 0) {
                    $('.v-dynamicEditorTable', editor).hide();
                }

                if (maxRows && $(".v-dynamicTableBody tr:visible", editor).length < maxRows) {
                    $(".v-addRow", editor).show();
                }                

                $("form.validate-save").a4unsavedChanges("change");
            });

            editor.on("change", ".h-randomization-dropdown", function () {
                var context = $(this);
                var synchronizeWith = context.closest(".v-editableItem").find(".synchronizeWith");
                var value = context.val();
                
                if (value == "Synchronized") {
                    synchronizeWith.show();
                }
                else {
                    synchronizeWith.hide();
                    synchronizeWith.val("");
                }
                $(".v-synchronizeWithHeader", editor).toggle(($(".synchronizeWith:visible", editor).length > 0));

                updateItemRowState($(this));
            });

            editor.on("change", ".h-updateRowState", function () {
                updateItemRowState($(this));
            });

            editor.on("click", ".v-addRow", function () {
                var rowId = $(".v-dynamicTableBody tr", editor).length + 1;
                var rowPosition = $(".v-dynamicTableBody tr:visible", editor).length + 1;

                $('.v-dynamicEditorTable', editor).show();

                var newItem = $(".v-newItems .v-newItemBody tr", editor).clone();
                newItem.find(".v-itemIndex").html(rowPosition);
                newItem.find(".v-rowPosition").val(rowPosition);
                newItem.removeClass("row0");
                newItem.addClass("row" + rowId);

                var editorControlName = $(".editorControlName", editor).attr("id");
                $("input, select", newItem).each(function () {
                    $(this).attr("id", editorControlName + "[" + (rowId - 1) + "]" + $(this).attr("id"));
                    $(this).attr("name", editorControlName + "[" + (rowId - 1) + "]." + $(this).attr("name"));
                });

                newItem.appendTo($("table .v-dynamicTableBody", editor));

                bindBlockAutoComplete(newItem);

                bindVariablesAutoComplete(newItem);

                $(".row" + rowId + " input", editor).on("keypress", function (e) { return disableEnter(e); });
                $(".row" + rowId + " .synchronizeWith", editor).hide();

                updateSynchronizeWithValues(editor);

                if (maxRows && rowPosition >= maxRows) {
                    $(this).hide();
                }

                $("form.validate-save").a4unsavedChanges("change");
            });

            $(".v-dynamicTableBody tr", editor).each(function () {
                bindBlockAutoComplete($(this));

                bindVariablesAutoComplete($(this));
            });
        });
    }
}

function updateSynchronizeWithValues(editor) {
    var currentRowIndex = 1;
    var maxIndex = $(".v-editableItem:visible", editor).length;
    $(".synchronizeWith", editor).each(function () {
        var selectedValue = parseInt($(this).val(), 10);
        $(this).html("");

        for (var i = 1; i <= maxIndex; i++) {
            if (i != currentRowIndex) {
                $(this).append($("<option " + ((selectedValue == i) ? "selected='selected'" : "")  + " value=" + i + ">" + i + "</option>"))
            }
        }

        //$(this).val(selectedValue);
        currentRowIndex++;
    });
}

function bindBlockAutoComplete(item) {
    $(".h-block-autocomplete", item).a4autocomplete({
        valueProperty: "Id",
        labelProperty: "Name",
        ajaxAction: a4.getSurveyAction("GetBlocksForAutoComplete", "Questionnaire"),
        select: function (event, data) {
            if (data && data.item) {
                $("input[type=hidden]", $(this).parents("td")).val(data.item.Id);
                updateItemRowState($(this));
            } else {
                $("input[type=hidden]", $(this).parents("td")).val(0);
            }
        }
    });
}

function bindVariablesAutoComplete(item) {
    $(".h-variablesAutocomplete", item).a4autocomplete({
        ajaxAction: a4.getSurveyAction("GetVariablesForAutoComplete", "Shared"),
        ajaxParams: { "systemVariables": ["$L", "$PHONE", "$EMAIL", "$LCD", "$PIN", "$APPOINTMENT"] },
        altValueField: $(".h-variableValue", item),
        select: function (event, data) {
            if (data && data.item) {
                updateItemRowState($(this));
            }
        }
    });
}

function replaceItemIndexes(startItem, increaseStartItem) {
    // Replace order if item deleted
    var previousIndex = $(".v-itemIndex", startItem).html();

    // For cancel of delete
    if (increaseStartItem) {
        previousIndex++;
    }

    startItem.nextAll(".v-editableItem:visible").each(function () {
        $(".v-itemIndex", $(this)).html(previousIndex);
        $(".v-rowPosition", $(this)).val(previousIndex);
        updateItemRowState($(".v-rowPosition", $(this)));
        previousIndex++;
    });
}

function swapItemIndexes(item1, item2) {
    var item1Position = $(".v-rowPosition", item1).val();
    var item2Position = $(".v-rowPosition", item2).val();

    $(".v-rowPosition", item1).val(item2Position);
    $(".v-itemIndex", item1).html(item2Position);

    $(".v-rowPosition", item2).val(item1Position);
    $(".v-itemIndex", item2).html(item1Position);

    var item1State = $(".v-rowState", item1);
    if (item1State.val() == 1)
        item1State.val(3); // updated

    var item2State = $(".v-rowState", item2);
    if (item2State.val() == 1)
        item2State.val(3); // updated
}

function updateItemRowState(triggerField) {
    var stateField = $(".v-rowState", triggerField.parents(".v-editableItem"));
    if (stateField.val() == 1)
        stateField.val(3); // updated
}

function disableEnter(_e) {
    return (_e.keyCode != 13);
}

function changePinControlsState() {
    $(".v-generatePinControl").prop("disabled", isReadOnly || $(".h-disablePinControls").is(":checked"));
    $(".v-overridePinControl").prop("disabled", isReadOnly || !$(".h-disablePinControls").is(":checked") || $(".h-isSAMLAuthentification:checked").length > 0);
    toggleDisableableSections();
}

function showFilteringValueField(actionField) {
    var action = actionField.val();
    var fieldDiv = actionField.parent();
    $(".v-filterDeviceMessage", fieldDiv).toggle(action == "DisplayMessage");
    $(".v-filterDeviceUrl", fieldDiv).toggle(action == "RedirectToUrl");
}

function showQuitButtonTypeValueField(actionField) {
    var action = actionField.val();
    var fieldDiv = actionField.parent();
    $(".filterValues", fieldDiv).toggle(action == "BranchTo");
}

function updateSurveyLink(trigger) {
    var $s;

    if (trigger)
        $s = $(trigger).parents(".v-linkSection").first();
    else
        $s = $(".v-linkSection").first();

    if ($s.length > 0) {
        var linkField = $("#Link", $s);
        var baseUrl = $("#BaseSurveyUrl", $s).val();

       // var baseDomain = baseUrl.match(domainRegex)[1];

        if ($("#IsCustomSurveyLink:checked", $s).val() == "True") {
            baseUrl = baseUrl.substring(0, baseUrl.indexOf("?"));

            if (baseUrl.includes("localhost")) {
                baseUrl = baseUrl + "/";
            }

            var customSurveyIdentifier = $("#CustomSurveyIdentifier", $s).val()

            if (customSurveyIdentifier) {
                customSurveyIdentifier = RemoveInvalidCharacters(customSurveyIdentifier);
            }

            baseUrl = baseUrl + $("#ClientId", $s).val() + "/" + customSurveyIdentifier + "/";

            var customDomain = $("#CustomSurveyDomain", $s).val();
            if (customDomain.length > 0) {
                
                var hasProtocal = customDomain.indexOf("http") == 0;
                var domainRegex = /http[s]{0,1}:\/\/(.[^/]+)/;
                var protocol = customDomain.indexOf("https") == 0 ? "https" : "http";
                baseUrl = baseUrl.replace(domainRegex, (hasProtocal ? "" : protocol + "://") + customDomain);
            }
        }
        else {
            $("#CustomSurveyIdentifier", $s).val("");
            $("#CustomSurveyDomain", $s).val("");
        }

        linkField.val(baseUrl);
    }
}

function copySurveyLink(trigger) {
    

    var linkField = document.getElementById("Link");
    var previousValue = $(linkField).val();
    
    var paramSeparator = previousValue.indexOf("?") > 0 ? "&" : "?";
    
    var additionalArguments = "";
    if (trigger.hasClass("link-test")) additionalArguments = paramSeparator + "m=0";
    else if (trigger.hasClass("link-preview")) additionalArguments = paramSeparator +"m=1";

    $(linkField).val(previousValue + additionalArguments);

    var origSelectionStart, origSelectionEnd;
    origSelectionStart = linkField.selectionStart;
    origSelectionEnd = linkField.selectionEnd;

    linkField.select();
    linkField.setSelectionRange(0, 99999);

    var succeed;
    try {
        succeed = document.execCommand("copy");
    } catch (e) {
        succeed = false;
    }

    linkField.setSelectionRange(origSelectionStart, origSelectionEnd);
    $(linkField).val(previousValue);
    a4.showSuccessMessage(copySurveyLinkSuccessMessage);
}

function checkPanelSectionErrors() {
    var panelErrorMessage = $(".v-panelFilterErrorMessage .field-validation-error");
    if (panelErrorMessage.is(":visible")) {
        a4.showErrorMessage(panelErrorMessage.html());
    }
}

function initializeOfflineSettings() {
    var context = $(".h-offlineSettings");

    if (context.length > 0) {
        $(".h-contactsMultiSelect", context).a4autocomplete({
            ajaxAction: a4.getAction("GetUsersForAutoComplete", "Shared"),
            valueProperty: "Id",
            labelProperty: "UserName",
            multipleSelection: true,
            hideSelectedItems: true,
            altValueField: $("#ContactsJson", context)
        });
    }
}

function disableSurveyAccess(mode) {
    var isSAML = mode.val() == "SAML" || mode.hasClass("SAMLEnabled");
    var enforceNoCookieSaveNContinue = isSAML && mode.hasClass("v-enforceNoCookieSaveNContinue");

    if (enforceNoCookieSaveNContinue) {
        $("select[name='AllowSaveNContinue'] option[value='NoCookie']").prop('selected', true);
    }

    $("select[name='AllowSaveNContinue']").prop("disabled", enforceNoCookieSaveNContinue);
    $("input[name='SAMLAttribute']").prop("readonly", !isSAML);
    $(".v-overridePinControl").prop("disabled", isSAML);
    $("input[name='Password']").prop("disabled", isSAML);
    //$("select[name='AllowSaveNContinue']").prop("disabled", isSAML);
}